
#ifndef _1_CRYS_ATP_TST_ECC_Acceptance_h_H
#define _1_CRYS_ATP_TST_ECC_Acceptance_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"

#if TST_USE_ECC_DATA/*In case no test vectors are selected - code disabled*/

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Wed Jan 12 12:18:08 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_ECC_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ Typedefs  ****************************/
/************************ Structs  ******************************/
typedef struct TST_ECC_SignVerifyTestDataStruct{	
    char					    TST_Name[TST_NAME_STRING_LEN];
    CRYS_ECPKI_DomainID_t		TST_CRYS_ECPKI_DomainID;
    CRYS_ECPKI_HASH_OpMode_t    TST_HashMode;
    DxUint8_t 					TST_input_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];	
    DxUint32_t                  TST_input_dataSize;
    DxUint8_t                   TST_ExternalPublKey[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPublKeySize;
    DxUint8_t                   TST_ExternalPrivKey[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPrivKeySize;
    DxUint8_t                   TST_output_signiture[TST_ECC_DATA_VEC_SIZE_IN_BYTS];
    DxUint32_t                  TST_SignitureSize;
} TST_ECC_SignVerifyTestDataStruct;

typedef struct TST_ECC_DH_TestDataStruct{	
    char					    TST_Name[TST_NAME_STRING_LEN];
    CRYS_ECPKI_DomainID_t		TST_CRYS_ECPKI_DomainID;
    DxUint8_t                   TST_ExternalPublKey1[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPublKey1Size;
    DxUint8_t                   TST_ExternalPrivKey1[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPrivKey1Size;
    DxUint8_t                   TST_ExternalPublKey2[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPublKey2Size;
    DxUint8_t                   TST_ExternalPrivKey2[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPrivKey2Size;
} TST_ECC_DH_TestDataStruct;

typedef struct TST_ECC_EncDecTestDataStruct{	
    char					    TST_Name[TST_NAME_STRING_LEN];
    CRYS_ECPKI_DomainID_t		TST_CRYS_ECPKI_DomainID;
    DxUint8_t 					TST_input_data[TST_ECC_DATA_VEC_SIZE_IN_BYTS];	
    DxUint32_t                  TST_input_dataSize;
    DxUint8_t                   TST_ExternalPublKey[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPublKeySize;
    DxUint8_t                   TST_ExternalPrivKey[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPrivKeySize;
    DxUint8_t                   TST_output_data[TST_ECC_DATA_VEC_SIZE_IN_BYTS];
    DxUint32_t                  TST_output_dataSize;
    DxUint8_t                   TST_Decrypted_data[TST_ECC_DATA_VEC_SIZE_IN_BYTS];
    DxUint32_t                  TST_Decrypted_dataSize;
} TST_ECC_EncDecTestDataStruct;
/************************ Public Variables **********************/
/************************ Public Functions **********************/
/*********************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_ECC_Acceptance_ECDSA_NonIntegratedSignVerify        
* 
* Description:                                                                 
*  This function Is a Acceptance test for ECC ESDSA Sign & Verify                   
*  This function Signs & Verifies known vectors 
* Algorithm:       
*  1. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key 
*     b. Build the Public Key 
*  2. Call the CRYS_ECDSA_SignInit to init the Sign operation
*  3. Call the CRYS_ECDSA_SignUpdate - This function is called N times
*                                        (N = number of blocks in data each block is 16byte)
*  4. Call the CRYS_ECDSA_SignFinish to complete the sign operation
*  5. Call the CRYS_ECDSA_VerifyInit to init the verification operation
*  7. Call the CRYS_ECDSA_VerifyUpdate - This function is called N times
*                                        (N = number of blocks in data each block is 16byte)
*  7.Call the CRYS_ECDSA_VerifyFinish to complete the verification operation     
*
* Inputs:
*  None
*
* Outputs:
*  CRYSError_t - Function error return         
*
*******************************************************************************/    							
CRYSError_t CRYS_ATP_TST_ECC_Acceptance_ECDSA_NonIntegratedSignVerify  ( int TST_KeyGeneration_TestStatus);

/*********************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_ECC_Acceptance_ECDSA_IntegratedSignVerify        
* 
* Inputs:
*  None
*
* Outputs:
*  CRYSError_t - Function error return                                     
*                                
*
* Description:                                                                 
*  This function Is a Acceptance test for ECC ESDSA Sign & Verify                   
*  This function Signs & Verifies known vectors 
* Algorithm:       
*  1. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key 
*     b. Build the Public Key 
*  2. Call CRYS_ECDSA_Sign to perform the sign operation
*  3. Call CRYS_ECDSA_Verify to perform the verification operation   
*
******************************************************************************/    
CRYSError_t CRYS_ATP_TST_ECC_Acceptance_ECDSA_IntegratedSignVerify  (  int TST_KeyGeneration_TestStatus );

/*********************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_ECC_Acceptance_DH        
* 
* Inputs:
*  None
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:                                                                      
* To test the Diffie-Hellman key shared secret generation using ECC capabilities
*
* Algorithm: 
* 1.Build or generate the private and public keys for user 1 using       
*     a. Generate keys 
*     or
*     a. Build the Private Key 
*     b. Build the Public Key 
* 2.Build or generate the private and public keys for user 2 using 
*     a. Generate keys 
*     or
*     a. Build the Private Key 
*     b. Build the Public Key 
* 3. Call CRYS_ECDH_SVDP_DH  to Create a shared secret 1 for user 1 
*    using user1 private key and user 2 public key 
* 4. Call CRYS_ECDH_SVDP_DH  to Create a shared secret 2 for user 2 
*    using user2 private key and user 1 public key
* 5. Compare the two secret keys - to verify they are identical
*
******************************************************************************/  
CRYSError_t CRYS_ATP_TST_ECC_Acceptance_DH  (  int TST_KeyGeneration_TestStatus );

/*********************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_ECC_Acceptance_ElGamal_EncDec        
* 
* Inputs:
*  None
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:                                                                      
* To test the El-Gamal algorithm for encryption and decryption
*
* Algorithm:      
*  1. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key 
*     b. Build the Public Key 
* 2. Encrypt a block of data using the CRYS_ECPKI_ELGAMAL_Encrypt encryption process
* 3. Decrypt a block of data using CRYS_ECPKI_ELGAMAL_Decrypt decryption process 
* 4. Compare the decrypted data to the original data
*
******************************************************************************/   
CRYSError_t CRYS_ATP_TST_ECC_Acceptance_ElGamal_EncDec  ( int TST_KeyGeneration_TestStatus );

/*********************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_ECC_Acceptance_ImportExportKeyPair        
* 
* Inputs:
*  None
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:                                                                      
* To test the ECC export public key functionality
*
* Algorithm:      
*  1. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key 
*     b. Build the Public Key 
*  2.	Export the public key using CRYS_ECPKI_ExportPublKey
*  3.	Re-build the exported key using CRYS_ECPKI_Build_PubKey
*  4.	Sign a massage using the exported public key using CRYS_ECDSA_Sign to perform the sign operation
*  5.	Verify the massage using the appropriate public key using CRYS_ECDSA_Verify
*      to perform the verification operation
*
******************************************************************************/  
CRYSError_t CRYS_ATP_TST_ECC_Acceptance_ImportExportKeyPair  ( int TST_KeyGeneration_TestStatus);

#ifdef __cplusplus
}
#endif

#endif

#endif




